# LibOFXConfig.cmake provides information about the installed LibOFX library.
# It can be used directly from CMake via find_package(libofx NO_MODULE)
#
# The following CMake variables are provided:
#   LibOFX_INCLUDE_DIR            - the include directory
#   LibOFX_LIBDIR                 - the library directory
#   LibOFX_DATADIR                - the data dir, contains the .dtd/.dcl files
#
# The following imported library targets are created, which may be used directly
# with target_link_libraries():
#   libofx::libofx                - the LibOFX library


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was LibOFXConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/LibOFXTargets.cmake")

include(CMakeFindDependencyMacro)

if (${CMAKE_VERSION} VERSION_LESS 3.25.0)
    set("${CMAKE_FIND_PACKAGE_NAME}_CMAKE_MODULE_PATH_save" "${CMAKE_MODULE_PATH}")
    list(INSERT CMAKE_MODULE_PATH 0 "${CMAKE_CURRENT_LIST_DIR}")

    find_dependency(OpenSP)

    set(CMAKE_MODULE_PATH "${${CMAKE_FIND_PACKAGE_NAME}_CMAKE_MODULE_PATH_save}")
    unset("${CMAKE_FIND_PACKAGE_NAME}_CMAKE_MODULE_PATH_save")
else()
    find_dependency(OpenSP)
endif()

if(ON)
    find_dependency(Iconv)
endif()

set_and_check(LibOFX_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(LibOFX_LIBDIR "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(LibOFX_DATADIR "${PACKAGE_PREFIX_DIR}/share")

check_required_components(LibOFX)
